<?php
namespace Import\ApiBundle\DataFixtures\ORM;

use Doctrine\Common\Persistence\ObjectManager;
use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Import\ApiBundle\Entity\GpwType;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

class LoadGpwTypes extends AbstractFixture implements OrderedFixtureInterface, ContainerAwareInterface
{
    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * @var \Doctrine\ORM\EntityManager
     */
    private $EntityManager;

    private $types = array(
        array(
            'symbol' => 'CGL',
            'name' => 'Notowania ciągłe - akcje, akcje NFI i indeksy GPW',
            'importUrl'=>'http://bossa.pl/pub/ciagle/mstock/sesjacgl/few_last.zip'
        ),
        array(
            'symbol' => 'FUT',
            'name' => 'Rynek kontraktów terminowych i opcji GPW',
            'importUrl'=>'http://bossa.pl/pub/futures/mstock/sesjafut/few_last.zip'
        ),
        array(
            'symbol' => 'CN',
            'name' => 'Rynek NewConnect',
            'importUrl'=>'http://bossa.pl/pub/newconnect/mstock/sesjancn/few_last.zip'
        ),
        array(
            'symbol' => 'OBL',
            'name' => 'Notowania ciągłe - obligacje GPW i Catalyst',
            'importUrl'=>'http://bossa.pl/pub/ciagle/mstock/sesjaobl/few_last.zip'
        ),
        array(
            'symbol' => 'ZGR',
            'name' => 'Indeksy giełd zagranicznych',
            'importUrl'=>'http://bossa.pl/pub/indzagr/mstock/sesjazgr/few_last.zip'
        ),
        array(
            'symbol' => 'NBP',
            'name' => 'Waluty w NBP',
            'importUrl'=>'http://bossa.pl/pub/waluty/mstock/sesjanbp/few_last.zip'
        ),
        array(
            'symbol' => 'FUN',
            'name' => 'Wartości netto jednostek funduszy inwestycyjnych',
            'importUrl'=>'http://bossa.pl/pub/fundinwest/mstock/sesjafun/few_last.zip'
        ),
        array(
            'symbol' => 'OFE',
            'name' => 'Wartości jednostek funduszy emerytalnych',
            'importUrl'=>'http://bossa.pl/pub/ofe/mstock/sesjaofe/few_last.zip'
        ),
    );

    /**
     * {@inheritDoc}
     */
    public function setContainer(ContainerInterface $container = null)
    {
        $this->container = $container;
    }

    public function load(ObjectManager $EntityManager)
    {
        $this->EntityManager = $EntityManager;

        foreach($this->types as $type)
        {
            $GpwType = $this->getGpwTypeBySymbol($type['symbol']);
            if(empty($GpwType))
            {
                $GpwType = new GpwType();
            }

            $GpwType->setSymbol($type['symbol']);
            $GpwType->setName($type['name']);
            $GpwType->setImportUrl($type['importUrl']);

            $this->EntityManager->persist($GpwType);
        }

        $this->EntityManager->flush();
    }


    private function getGpwTypeBySymbol($symbol)
    {
        return $this->EntityManager->getRepository('ImportApiBundle:GpwType')->findOneBy(array('symbol' => $symbol));
    }

    public function getOrder()
    {
        return 5000;
    }
}